VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMBBusObject"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' HTML TAG constants
Private Const PLUS_IMAGE As String = "<IMG SRC='./pageimages/plus.gif' align=absMiddle "
Private Const MESSAGE_IMAGE As String = "<IMG     align=top src='./pageimages/message.gif' border=0 style='MARGIN-BOTTOM : 1px'"
Private Const NONIE_MESSAGE_IMAGE As String = "<IMG  align=top src='./pageimages/message.gif' border=0 "
Private Const SPAN_TAG As String = "<SPAN style='DISPLAY: none' "
Private Const IENEW_ROW_IVORY As String = "<TR bgcolor=Ivory><TD NOWRAP><DL><DD "
Private Const IENEW_ROW_LACE As String = "<TR bgcolor=OldLace><TD NOWRAP><DL><DD "

' Enumerator for type of message in thread
' Used in GetMessages and GetNonIEMessages methods
Private Enum MessageType
    TopLevel
    NewSubLevel
    Message
End Enum

' Connection string for ODBC datasource
Private Const DBCONNSTRING = "DSN=MessageBoard;UID=MBUser;PWD=inabottle"

Public Function GetMessages(lMessageBoardID As Long, sDateFrom As String, sDateTo As String, sLastVisit As String, sErrorString As String) As String
On Error GoTo ErrorHandler

Dim loReplies As New Dictionary ' Stores MessageId of messages with a reply
Dim loAppendSubject As New CStringBuffer ' Contains Subject HTML String
Dim loAppendPerson As New CStringBuffer ' Contains Person HTML String
Dim loAppendDate As New CStringBuffer ' Contains Date HTML String
Dim lsMessageId As String
Dim lsNames As String   ' Used for TAG Name and ID
Dim llPrevMessageId As Long
Dim llPrevIndent As Long
Dim lsFinalEndString As String ' Final end string varies depending on no. replies
Dim lsEndString As String
Dim lsTemp As String
Dim llMessageType As MessageType ' Enum MessageType
Dim lsDDStyle As String
Dim lbColour As Boolean ' Used for Thread colour block switching
Dim llIndents As Long
Dim lsTitle As String

Dim llRecordCounter As Long
Dim loConn As New ADODB.Connection
Dim loRS As New ADODB.Recordset
Dim vRecordsReturned() As Variant

    loConn.Open DBCONNSTRING
' Populate loReplies Dictionary Object
    loRS.Open "NumberOfReplies " & CStr(lMessageBoardID), loConn
    If Not (loRS.BOF And loRS.EOF) Then
        vRecordsReturned = loRS.GetRows(Fields:="MessageId")
    
        ' returned in arrays as (Cols, Rows)
        For llRecordCounter = 0 To UBound(vRecordsReturned, 2)
            loReplies.Add CStr(vRecordsReturned(0, llRecordCounter) & ">"), ""
        Next llRecordCounter
    End If
    
    loRS.Close
loRS.Open "Exec GetMessages " & CStr(lMessageBoardID) & ",'" & sLastVisit & "'", loConn
If Not (loRS.BOF And loRS.EOF) Then

' Following columns returned
' MessageId,Indents,MessageOrder,VisitorName
' Email,DateSent,Subject,Message,NewMessageID
   
' returned in arrays as (Cols, Rows)
        
' a gotcha is if you define vFieldNames to be larger than the number of columns  returned
        Dim vFieldNames(6) As Variant
        vFieldNames(0) = "MessageId"
        vFieldNames(1) = "Indents"
        vFieldNames(2) = "Email"
        vFieldNames(3) = "DateSent"
        vFieldNames(4) = "Subject"
        vFieldNames(5) = "VisitorName"
        vFieldNames(6) = "NewMessageID"
    
    vRecordsReturned = loRS.GetRows(Fields:=vFieldNames)
' Loop through each row in array
    For llRecordCounter = 0 To UBound(vRecordsReturned, 2)
    
    ' If Font Bold style for messages posted after users last visit  - Plain Font otherwise
    lsDDStyle = IIf(vRecordsReturned(0, llRecordCounter) = vRecordsReturned(6, llRecordCounter), " CLASS='clsBoldDD' ", " CLASS='clsNormalDD' ")
    
    lsMessageId = CStr(vRecordsReturned(0, llRecordCounter)) & ">"
    llIndents = vRecordsReturned(1, llRecordCounter)
' What Level of message - Top, 1st reply, or 2nd reply and greater
    If llIndents = 0 Then
        llMessageType = TopLevel
    Else
        llMessageType = IIf(llPrevIndent <> llIndents, NewSubLevel, Message)
    End If
    vRecordsReturned(2, llRecordCounter) = Trim(vRecordsReturned(2, llRecordCounter))
    
    ' Setting HTML tag title to the e-mail address means it will be displayed when users mouse hovers
    ' over Person name in Message Board
    lsTitle = IIf(vRecordsReturned(2, llRecordCounter) = "", "", " TITLE='" & vRecordsReturned(2, llRecordCounter) & "' ")
If llMessageType = TopLevel Then
    
        
        ' If this is not the first message thread, then append HTML close Tags
        If llRecordCounter > 0 Then
            loAppendSubject.Append loAppendPerson.Value
            loAppendPerson.Clear
                    
            loAppendSubject.Append loAppendDate.Value
            loAppendDate.Clear
            
            lsFinalEndString = "</DL></TD>"
            
        End If
'
            ' Append Subject
            '
            
            ' Append Close Tags for previous message Thread
            ' HTML close tags for <SPAN> and <DL>
            If llPrevIndent = 1 Then loAppendSubject.Append "</SPAN></DL>"
            loAppendSubject.Append lsFinalEndString
            
            ' Start new row with new colour
            lbColour = Not lbColour
            loAppendSubject.Append IIf(lbColour, IENEW_ROW_LACE, IENEW_ROW_IVORY)
    
            ' If a message has replies - put the + sign image next to subject
            If loReplies.Exists(lsMessageId) Then
                ' Make name of tags the messageid - this will be used in browser for displaying messages
                loAppendSubject.Append lsDDStyle & " STYLE='MARGIN-LEFT: 10px' id=MSGS" & lsMessageId
                loAppendSubject.Append PLUS_IMAGE & "id=ImgSub" & lsMessageId
            Else
                loAppendSubject.Append lsDDStyle & " STYLE='MARGIN-LEFT: 26px' id=MSGS" & lsMessageId
            End If
            loAppendSubject.Append MESSAGE_IMAGE & " id=MSGI" & lsMessageId
            loAppendSubject.Append vRecordsReturned(4, llRecordCounter)
'
            ' Append Person
            '
            lsEndString = "</DL>"
            loAppendPerson.Append lsEndString
            loAppendPerson.Append lsFinalEndString
            loAppendPerson.Append "<TD NOWRAP><DL><DD "
            loAppendPerson.Append lsTitle & lsDDStyle & " STYLE='MARGIN-LEFT : 10px' id=MSGP" & lsMessageId
            loAppendPerson.Append vRecordsReturned(5, llRecordCounter)
            '
            ' Append Date
            '
            loAppendDate.Append lsEndString
            loAppendDate.Append lsFinalEndString
            loAppendDate.Append "<TD NOWRAP><DL><DD STYLE='MARGIN-LEFT: 10px' "
            loAppendDate.Append lsDDStyle & " id=MSGD" & lsMessageId
            loAppendDate.Append Format(vRecordsReturned(3, llRecordCounter), "dd mmm yy hh:mm")
Else
' Create the HTML close tags for last sub section(s)
            lsEndString = ""
                     
' Are we moving up out of the sub messages - close off Tags if we are
    If llPrevIndent > llIndents Then
                Do While llPrevIndent <> llIndents
                    lsEndString = lsEndString & "</DL></SPAN>"
                    llPrevIndent = llPrevIndent - 1
                Loop
            End If
            loAppendSubject.Append lsEndString
          
        ' Is this the start of a new sub section higher up the message thread
            If llMessageType = NewSubLevel Then
                If llPrevIndent < llIndents Then
                    loAppendSubject.Append SPAN_TAG & "id=SubjectSub" & CStr(llPrevMessageId) & "><DL>"
                End If
            End If
' Append Subject
        If loReplies.Exists(lsMessageId) Then
                loAppendSubject.Append "<DD STYLE='MARGIN-LEFT: 20px' " & lsDDStyle & " id=MSGS" & lsMessageId
                loAppendSubject.Append PLUS_IMAGE & "id=ImgSub" & lsMessageId
            Else
                loAppendSubject.Append "<DD style='MARGIN-LEFT: 36px'" & lsDDStyle & " id=MSGS" & lsMessageId
            End If
            loAppendSubject.Append MESSAGE_IMAGE & " id=MSGI" & lsMessageId
            loAppendSubject.Append vRecordsReturned(4, llRecordCounter)
             '
            ' Append Person
            '
            ' Remove <DL> tags to leave just <SPAN> tags
            lsEndString = Replace(lsEndString, "</DL>", "")
            loAppendPerson.Append lsEndString
            
            If llMessageType = NewSubLevel Then
                If llPrevIndent < llIndents Then
                    loAppendPerson.Append SPAN_TAG & "id=PersonSub" & CStr(llPrevMessageId) & ">"
                End If
            End If
            loAppendPerson.Append "<DD STYLE='MARGIN-LEFT: 10px' " & lsTitle & lsDDStyle & "  id=MSGP" & lsMessageId
            loAppendPerson.Append vRecordsReturned(5, llRecordCounter)
            '
            ' Append Date
            '
            loAppendDate.Append lsEndString
            
            If llMessageType = NewSubLevel Then
                If llPrevIndent < llIndents Then
                    loAppendDate.Append SPAN_TAG & "id=DateSub" & CStr(llPrevMessageId) & ">"
                End If
            End If
            loAppendDate.Append "<DD STYLE='MARGIN-LEFT: 10px' " & lsDDStyle & " id=MSGD" & lsMessageId
            loAppendDate.Append Format(vRecordsReturned(3, llRecordCounter), "dd mmm yy hh:mm")
    End If
llPrevMessageId = vRecordsReturned(0, llRecordCounter)
llPrevIndent = llIndents
 
Next llRecordCounter
' Join Subject, Person and Date HTML to make final
    ' string to be passed back to webclass
    loAppendSubject.Append loAppendPerson.Value
    loAppendSubject.Append loAppendDate.Value
    GetMessages = loAppendSubject.Value & "</DL></SPAN>"
Else
    ' Where a message board with no message - no HTML!!!
    GetMessages = ""
End If
Exit Function

ErrorHandler:
    GetMessages = "Error in GetMessages " & Err.Description
    sErrorString = Err.Description
End Function

Public Sub AddMessage(sSubject As String, sName As String, sEmail As String, sMessage As String, sRemote_Address As String, lMessageBoardID As Long, sErrorString As String, Optional lMessageID As Long = -1)

On Error GoTo ErrorHandler

    ' Prevent it failure due to a too long a string being passed
    If Len(sMessage) > 4000 Then sMessage = Left$(sMessage, 4000)
    If Len(sName) > 20 Then sName = Left$(sName, 20)
    If Len(sSubject) > 40 Then sSubject = Left$(sSubject, 40)
    If Len(sEmail) > 50 Then sEmail = Left$(sEmail, 50)

    Dim loPrm As ADODB.Parameter
    Dim loCommand As New ADODB.Command
    
    ' Create and open ADO connection
    Dim loConn As New ADODB.Connection
    loConn.Open DBCONNSTRING
    loConn.CursorLocation = adUseClient
    
    ' Create ADO command object which will execute our stored procedure
    loCommand.CommandText = "AddMessage"
    loCommand.CommandType = adCmdStoredProc
    loCommand.Name = "AddMessage"
    
    ' MessageID ofg -1 indicates to
    ' stored procedure used that this is a new message
    lMessageID = IIf(lMessageID = 0, -1, lMessageID)
' Manually Populate Command Object's parameters
    
    Set loPrm = loCommand.CreateParameter("RV", adInteger, adParamReturnValue)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("VisitorName", adVarChar, adParamInput, 20)
    loCommand.Parameters.Append loPrm
      
    Set loPrm = loCommand.CreateParameter("Email", adVarChar, adParamInput, 50)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("Subject", adVarChar, adParamInput, 40)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("Message", adVarChar, adParamInput, 4000)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("Remote_Address", adVarChar, adParamInput, 50)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("MessageBoardId", adInteger, adParamInput, 25)
    loCommand.Parameters.Append loPrm
    
    Set loPrm = loCommand.CreateParameter("ReplyToMessageId", adInteger, adParamInput)
    loCommand.Parameters.Append loPrm
' Execute Command - AddMessage stored procedure will add message to database
    Set loCommand.ActiveConnection = loConn
    loConn.AddMessage sName, sEmail, sSubject, sMessage, sRemote_Address, lMessageBoardID, lMessageID
    
    ' If the new message insert failed then pass this knowledge onto
    ' presentation component which can let the user know
    If loCommand.Parameters("RV") <> 0 Then
        Err.Raise vbObjectError, "AddMessage", "ADDFAILED"
    End If
    loConn.Close
    
    Set loCommand = Nothing
    Set loConn = Nothing
    Exit Sub

ErrorHandler:
    sErrorString = Err.Description

End Sub

Public Function GetNonIEMessages(lMessageBoardID As Long, sErrorString As String, Optional sTemplateURL, Optional lMessageID As Long = -1) As String
On Error GoTo ErrorHandler

' String Buffers to hold HTML
Dim loSubjectHTML As New CStringBuffer
Dim loPersonHTML As New CStringBuffer
Dim loDateHTML As New CStringBuffer

Dim lsMessageId As String
Dim llPrevIndent As Long
Dim lsFinalEndString As String
Dim lsEndString As String
Dim llMessageType As MessageType
Dim lsColour As String
Dim lsEmail As String
Dim vRecordsReturned() As Variant
Dim llRecordCounter As Long
Dim llIndents As Long

lsColour = "Ivory"

Dim loRS As New ADODB.Recordset

' Get all messages or just get messages for single thread group
If lMessageID = -1 Then
    loRS.Open "Exec GetMessages " & CStr(lMessageBoardID) & ",''", DBCONNSTRING
Else
    loRS.Open "Exec GetMessageThread " & CStr(lMessageBoardID) & "," & CStr(lMessageID), DBCONNSTRING
End If

If Not (loRS.BOF And loRS.EOF) Then

    ' Don't dim more than you use or it will fail
    Dim vFieldNames(5) As Variant
    vFieldNames(0) = "MessageId"
    vFieldNames(1) = "Indents"
    vFieldNames(2) = "Email"
    vFieldNames(3) = "DateSent"
    vFieldNames(4) = "Subject"
    vFieldNames(5) = "VisitorName"
         
    vRecordsReturned = loRS.GetRows(Fields:=vFieldNames)
    
    For llRecordCounter = 0 To UBound(vRecordsReturned, 2)
    
    lsMessageId = CStr(vRecordsReturned(0, llRecordCounter))
    
    ' Create a mailto hyperlink if an e-mail address supplied
    vRecordsReturned(2, llRecordCounter) = Trim(vRecordsReturned(2, llRecordCounter))
    lsEmail = IIf(vRecordsReturned(2, llRecordCounter) = "", "", "<A HREF='MAILTO:" & vRecordsReturned(2, llRecordCounter) & "'>")
    
    llIndents = vRecordsReturned(1, llRecordCounter)
    
    ' Determine type of message position in thread
    If vRecordsReturned(1, llRecordCounter) = 0 Then
        llMessageType = TopLevel
    Else
        llMessageType = IIf(llPrevIndent < llIndents, NewSubLevel, Message)
    End If
    ' Build HTML for top section message
    If llMessageType = TopLevel Then
    
            ' Append previous message's Person and Subject HTML
            ' to subject buffer
            If llRecordCounter > 0 Then
                
                Do While llPrevIndent > 0
                    loSubjectHTML.Append "</DL>"
                    llPrevIndent = llPrevIndent - 1
                Loop
            
                loSubjectHTML.Append "</DL></TD>"
            
                loPersonHTML.Append "</DL></TD>"
                loSubjectHTML.Append loPersonHTML.Value
                loPersonHTML.Clear
            
                loDateHTML.Append "</DL></TD>"
                loSubjectHTML.Append loDateHTML.Value
                loDateHTML.Clear
                loSubjectHTML.Append "</TR>"
            End If
            '
            ' Append Subject
            '
            
            
            lsColour = IIf(lsColour = "OldLace", "Ivory", "OldLace")
            loSubjectHTML.Append "<TR bgcolor=" & lsColour & " ><TD NOWRAP><DL>"
            
            ' Add hyperlink
            loSubjectHTML.Append "<DD><A HREF='" & sTemplateURL & "&WCU=" & lsMessageId & "'>" & vbCrLf
            loSubjectHTML.Append NONIE_MESSAGE_IMAGE & ">" & vbCrLf
            loSubjectHTML.Append vRecordsReturned(4, llRecordCounter) & "</A></DD>" & vbCrLf
     
            '
            ' Append Person
            '
            loPersonHTML.Append "<TD NOWRAP><DL><DD>" & lsEmail
            loPersonHTML.Append vRecordsReturned(5, llRecordCounter)
            loPersonHTML.Append IIf(lsEmail = "", "", "</A>") & "</DD>"
            '
            ' Append Date
            '
            loDateHTML.Append "<TD NOWRAP><DL><DD>"
            loDateHTML.Append Format(vRecordsReturned(3, llRecordCounter), "dd mmm yy hh:mm") & "</DD>"
        Else
            lsEndString = ""
                     
            If llPrevIndent > llIndents Then
                Do While llPrevIndent <> llIndents
                    lsEndString = lsEndString & "</DL>"
                    llPrevIndent = llPrevIndent - 1
                Loop
            End If
            loSubjectHTML.Append lsEndString
            ' NewSubLevel message only
            If llMessageType = NewSubLevel Then
                loSubjectHTML.Append "<DL>"
            End If
            
            ' Add Hyperlink
            loSubjectHTML.Append "<DD><A HREF='" & sTemplateURL & "&WCU=" & lsMessageId & "'>" & vbCrLf
            loSubjectHTML.Append NONIE_MESSAGE_IMAGE & ">" & vbCrLf
            loSubjectHTML.Append vRecordsReturned(4, llRecordCounter) & "</A></DD>" & vbCrLf
            '
            ' Append Person
            '
            loPersonHTML.Append lsEndString
            loPersonHTML.Append "<DD>" & lsEmail
            loPersonHTML.Append vRecordsReturned(5, llRecordCounter)
            loPersonHTML.Append IIf(lsEmail = "", "", "</A>") & "</DD>"
            '
            ' Append Date
            '
            loDateHTML.Append lsEndString
            loDateHTML.Append "<DD>"
            loDateHTML.Append Format(vRecordsReturned(3, llRecordCounter), "dd mmm yy hh:mm") & "</DD>"
        End If

    llPrevIndent = vRecordsReturned(1, llRecordCounter)
   
    Next llRecordCounter
    
    Do While llPrevIndent > 0
        loSubjectHTML.Append "</DL>"
        llPrevIndent = llPrevIndent - 1
    Loop
            
    ' Append Final Thread block onto HTML
    loSubjectHTML.Append "</DL></TD>"
    
    loPersonHTML.Append "</DL></TD>"
    loSubjectHTML.Append loPersonHTML.Value
    loPersonHTML.Clear
            
    loDateHTML.Append "</DL></TD>"
    loSubjectHTML.Append loDateHTML.Value
    loDateHTML.Clear
    loSubjectHTML.Append "</TR>"
    GetNonIEMessages = loSubjectHTML.Value
Else
    ' Empty recordset - no messages so no HTML
    GetNonIEMessages = ""
End If
Exit Function

ErrorHandler:
    GetNonIEMessages = "Error in GetNonIEMessages " & Err.Description
    sErrorString = Err.Description

End Function
Public Function GetMessage(lMessageBoardID As Long, lMessageID As Long, sErrorString As String) As String
On Error GoTo ErrorHandler
    
    Dim loRS As New ADODB.Recordset
    loRS.Open "Exec GetMessage " & CStr(lMessageBoardID) & "," & CStr(lMessageID), DBCONNSTRING
    GetMessage = CStr(loRS("Message"))
    loRS.Close
    Set loRS = Nothing

Exit Function

ErrorHandler:
    GetMessage = "Error in GetMessage " & Err.Description
    sErrorString = Err.Description

End Function


Public Function GetNonIEMessage(lMessageBoardID As Long, lMessageID As Long, sErrorString As String) As String
On Error GoTo ErrorHandler
    Dim loRS As New ADODB.Recordset
    Dim lsMessage As String
    Dim lsName As String

    loRS.Open "Exec GetMessage " & CStr(lMessageBoardID) & "," & CStr(lMessageID), DBCONNSTRING
    lsName = IIf(loRS("VisitorName") = "", loRS("Remote_Address"), loRS("VisitorName"))
    lsMessage = "<STRONG><FONT SIZE=5>" & loRS("Subject") & "</STRONG></FONT><BR><FONT SIZE=2>" & CStr(loRS("DateSent")) & "</FONT><BR><BR>" & "&nbsp;&nbsp;&nbsp;&nbsp;" & lsName & " writes " & "<BR><BR>"
    lsMessage = lsMessage & "<PRE>" & loRS("Message") & "</PRE>"
    loRS.Close
    Set loRS = Nothing
    GetNonIEMessage = lsMessage

    Exit Function

ErrorHandler:
    GetNonIEMessage = "Error in GetNonIEMessage " & Err.Description
    sErrorString = Err.Description
End Function


Public Function GetNonIEReplyDetails(lMessageBoardID As Long, lMessageID As Long, sErrorString As String) As String
On Error GoTo ErrorHandler
    
    ' Get message details from database
    Dim loRS As New ADODB.Recordset
    loRS.Open "Exec GetMessage " & CStr(lMessageBoardID) & "," & CStr(lMessageID), DBCONNSTRING
    
    ' Create HTML form INPUT tags and populate with message details
    GetNonIEReplyDetails = "<INPUT id=txtSubject name=txtSubject maxLength=40 VALUE='RE:" & loRS("Subject")
    GetNonIEReplyDetails = GetNonIEReplyDetails & "'></FONT></TD></TR><TR><TD><FONT face=Verdana><BR>Type your message here:</FONT></TD><TD></TD><TD></TD></TR><TR><TD colspan=3><FONT face=Verdana><TEXTAREA cols=60 id=txtMessage name=txtMessage rows=8>"
    GetNonIEReplyDetails = GetNonIEReplyDetails & vbCrLf & vbCrLf & vbCrLf & ">" & Replace(loRS("Message"), vbCrLf, ">" & vbCrLf) & "</TEXTAREA>"
    
    loRS.Close
    Set loRS = Nothing
    Exit Function

ErrorHandler:
    GetNonIEReplyDetails = "Error in GetNonIEReplyDetails " & Err.Description
    sErrorString = Err.Description

End Function

